<?php
/**
 * @package         WOSA front
 * @subpackage      IELTS/PTE..
 * @author          Navjeet
 *
 **/
class Become_agent extends MY_Controller{
    
    function __construct()
    {
        parent::__construct();   
    }
    
    function index()
    {   
		$headers = array(
            'API-KEY:'.WOSA_API_KEY,   
        );
        //$data['segment'] = $this->_getURI();
        $data['title'] = 'Become An Agent';
        $data['title1'] = 'Become An Agent';
        $data['title2'] = ' Become An Agent';

		$data['newsData']=json_decode($this->_curlGetData(base_url(GET_NEWS_DATA_URL), $headers));
		$data['serviceData']=json_decode($this->_curlGetData(base_url(GET_SERVICE_DATA_URL), $headers));
		$data['countryCode']=json_decode($this->_curlGetData(base_url(GET_ALL_CNT_CODE_URL), $headers));
        $this->load->view('aa-front-end/includes/header',$data);
        $this->load->view('aa-front-end/become_agent',$data);
        $this->load->view('aa-front-end/includes/footer');
    }  
	
    public function save_booking()
    {
        if (!$this->input->is_ajax_request()) {
            show_404();
        }
    
        $this->load->model('Become_agent_model');
        $this->load->library('form_validation');
    
        $this->form_validation->set_rules('fname','First Name','required|trim');
        $this->form_validation->set_rules('mobile','Mobile','required|trim');
        $this->form_validation->set_rules('email','Email','required|valid_email');
        $this->form_validation->set_rules('city','City','required|trim');
        $this->form_validation->set_rules('country','Country','required|trim');
    
        if ($this->form_validation->run() === FALSE) {
            echo json_encode([
                'error_message' => [
                    'success' => 0,
                    'message' => strip_tags(validation_errors())
                ]
            ]);
            return;
        }
    
        $params = [
            'fname'        => $this->input->post('fname', true),
            'lname'        => $this->input->post('lname', true),
            'email'        => $this->input->post('email', true),
            'country_code' => $this->input->post('country_code', true),
            'mobile'       => $this->input->post('mobile', true),
            'city'         => $this->input->post('city', true),
            'country'      => $this->input->post('country', true),
            'org_name'     => $this->input->post('org_name', true),
            'address'      => $this->input->post('address', true),
            'contact_date' => date('Y-m-d'),
            'created'      => date('Y-m-d H:i:s'),
            'modified'     => date('Y-m-d H:i:s')
        ];
    
        $id = $this->Become_agent_model->booking_detail_save($params);
    
        if ($id) {
            echo json_encode([
                'error_message' => [
                    'success'    => 1,
                    'message'    => 'Your request has been sent successfully',
                    'enquiry_id' => $id
                ]
            ]);
            return;
        }
    
        echo json_encode([
            'error_message' => [
                'success' => 0,
                'message' => 'Database insert failed'
            ]
        ]);
    }
    
    
}
