<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proxy extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
    }

    public function submit_agent() {
        // Get raw POST JSON
        $rawPost = file_get_contents("php://input");
        $postData = json_decode($rawPost, true);

        // Prepare cURL
        $url = site_url('Submit_enquiry_agent'); // your actual REST endpoint
        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'API-KEY: ' . WOSA_API_KEY
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        header('Content-Type: application/json');

        if ($error) {
            echo json_encode(['status' => 0, 'error' => $error]);
        } else {
            log_message('error', 'Submit_enquiry_agent response: ' . $response);
            echo $response;
        }
    }
}
