<?php
/**
 * @package         WOSA front
 * @subpackage      Purpose
 * @author          Vikrant
 *
 **/
class Purpose extends MY_Controller{
	
    function __construct()
    {
        parent::__construct();
    }

	function ajax_getPurposeLevel_2()
	{
		$purpose_level_1=$this->input->post('purpose_level_1');
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'purpose-level-one:'.$purpose_level_1
		);
		$data = json_decode($this->_curlGetData(base_url(GET_PURPOSE_LEVEL_TWO_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getCourse()
	{
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
		);
		$data = json_decode($this->_curlGetData(base_url(GET_COURSE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getProgram()
	{
		$course 		= $this->input->post('reality_test_course');
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course
		);
		$data = json_decode($this->_curlGetData(base_url(GET_PROGRAM_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getRealityTest()
	{
		$course 		= $this->input->post('reality_test_course');
		$program 		= $this->input->post('reality_test_program');
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course,
			'program:'.$program
		);
		$data = json_decode($this->_curlGetData(base_url(GET_REALITY_TEST_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getEventType()
	{
		if($this->input->post('purpose_level_2')==33)  // Academy
		{
			$division_id = ACADEMY_DIVISION_PKID;
		}
		elseif($this->input->post('purpose_level_2')==36) // Visa
		{
			$division_id = VISA_DIVISION_PKID;
		}
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'division-id:'.$division_id
		);
		$data = json_decode($this->_curlGetData(base_url(GET_EVENT_TYPE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getAcademyEvent()
	{
		if($this->input->post('purpose_level_2')==33)  // Academy
		{
			$division_id = ACADEMY_DIVISION_PKID;
		}
		
		$event_type		=	$this->input->post('event_type');
		$event_course	=	$this->input->post('event_course');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'division-id:'.$division_id,
			'event-type:'.$event_type,
			'event-course:'.$event_course
		);
		$data = json_decode($this->_curlGetData(base_url(GET_ACADEMY_EVENT_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getVisaEvent()
	{
		if($this->input->post('purpose_level_2')==36) // Visa
		{
			$division_id = VISA_DIVISION_PKID;
		}
		
		$event_type			=	$this->input->post('event_type');
		$event_int_country	=	$this->input->post('event_int_country');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'division-id:'.$division_id,
			'event-type:'.$event_type,
			'event-int-country:'.$event_int_country
		);
		$data = json_decode($this->_curlGetData(base_url(GET_VISA_EVENT_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getExamCity()
	{
		$course		=	$this->input->post('course');
		$program	=	$this->input->post('program');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course,
			'program:'.$program
		);
		$data = json_decode($this->_curlGetData(base_url(GET_EXAM_CITY_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getExamList()
	{
		$course		=	$this->input->post('course');
		$program	=	$this->input->post('program');
		$city		=	$this->input->post('city');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course,
			'program:'.$program,
			'city:'.$city
		);
		$data = json_decode($this->_curlGetData(base_url(GET_EXAM_LIST_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getOnlinePackage()
	{
		$course		=	$this->input->post('course');
		$program	=	$this->input->post('program');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course,
			'program:'.$program
		);
		$data = json_decode($this->_curlGetData(base_url(GET_ONLINE_PACKAGE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getOnlineCoachingProgram()
	{
		$course		=	$this->input->post('course');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course
		);
		$data = json_decode($this->_curlGetData(base_url(GET_ONLINE_COACHING_PROGRAM_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getInhousePackage()
	{
		$course		=	$this->input->post('course');
		$program	=	$this->input->post('program');
		$branch		=	$this->input->post('branch');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course,
			'program:'.$program,
			'branch:'.$branch
		);
		$data = json_decode($this->_curlGetData(base_url(GET_INHOUSE_PACKAGE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getPracticePackPackage()
	{
		$course		=	$this->input->post('course');
		$program	=	$this->input->post('program');
		
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'course:'.$course,
			'program:'.$program
		);
		$data = json_decode($this->_curlGetData(base_url(GET_PRACTICE_PACK_PACKAGE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getInhouseBranch()
	{
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
		);
		$data = json_decode($this->_curlGetData(base_url(GET_INHOUSE_BRANCH_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getIntCountry()
	{
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
		);
		$data = json_decode($this->_curlGetData(base_url(GET_INT_COUNTRY_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getQualification()
	{
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
		);
		$data = json_decode($this->_curlGetData(base_url(GET_QUALIFICATION_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getWorkExperience()
	{
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
		);
		$data = json_decode($this->_curlGetData(base_url(GET_WORK_EXPERIENCE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getIndustryType()
	{
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
		);
		$data = json_decode($this->_curlGetData(base_url(GET_INDUSTRY_TYPE_URL), $headers));
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
	function ajax_getPhoneLimit()
	{
		$country_code 		= $this->input->post('country_code');
		$headers = array(
			'API-KEY:'.WOSA_API_KEY,
			'country-code:'.$country_code
		);
		$data = json_decode($this->_curlGetData(base_url(GET_PHONE_LIMIT_URL), $headers));
		//pr($data,1);
		$response=array();
		if($data->error_message->success ==1 && count($data->error_message->data) >0){
			
			$response=$data->error_message->data;
		}
		echo json_encode($response);
		exit();
	}
	
}
