<?php
class Visa_services extends MY_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Main page (all parent categories)
    function index()
    {
        $headers = ['API-KEY:' . WOSA_API_KEY];

        $data['countryCode'] = json_decode($this->_curlGetData(base_url(GET_ALL_CNT_CODE_URL), $headers));
        $data['bannerList']   = json_decode($this->_curlGetData(base_url(GET_VISA_BANNER_URL), $headers));
        $data['newsData']     = json_decode($this->_curlGetData(base_url(GET_NEWS_DATA_URL), $headers));
        $data['serviceData'] = json_decode($this->_curlGetData(base_url(GET_SERVICE_DATA_URL), $headers));


        // Fetch parent categories (only slug + name)
        $data['categories'] = $this->db
            ->select('id, name, slug, image')
            ->where('parent_id IS NULL', null, false)
            ->where('status', 1)
            ->get('service_categories')
            ->result();

        $data['isSubCategoryPage'] = false;

        $this->load->view('aa-front-end/includes/header', $data);
        $this->load->view('aa-front-end/visa-services', $data);
        $this->load->view('aa-front-end/includes/footer');
    }

    // Subcategory page (parent → subcategories)
    function detail($parentSlug = null)
    {
        if (empty($parentSlug)) show_404();

        $parentSlug = urldecode($parentSlug);

        // Get parent by slug
        $parent = $this->db
            ->where('slug', $parentSlug)
            ->where('status', 1)
            ->get('service_categories')
            ->row();

        if (!$parent) show_404();

        // Get subcategories under this parent
        $subCategories = $this->db
            ->select('id, name, slug, image')
            ->where('parent_id', $parent->id)
            ->where('status', 1)
            ->get('service_categories')
            ->result();

        if (empty($subCategories)) show_404();

        $data = [
            'subCategories' => $subCategories,
            'isSubCategoryPage' => true,
            'parentSlug' => $parent->slug,
            'parentName' => $parent->name
        ];

        // Fetch banners/news
        $headers = ['API-KEY:' . WOSA_API_KEY];
        $data['bannerList'] = json_decode($this->_curlGetData(base_url(GET_VISA_BANNER_URL), $headers));
        $data['newsData']   = json_decode($this->_curlGetData(base_url(GET_NEWS_DATA_URL), $headers));

        $this->load->view('aa-front-end/includes/header', $data);
        $this->load->view('aa-front-end/visa-services', $data);
        $this->load->view('aa-front-end/includes/footer');
    }

    // Subcategory detail page
    public function subcategory($parentSlug = null, $subSlug = null)
    {
        if (empty($parentSlug) || empty($subSlug)) show_404();

        $headers = ['API-KEY:' . WOSA_API_KEY];

        $data['countryCode'] = json_decode($this->_curlGetData(base_url(GET_ALL_CNT_CODE_URL), $headers));
        $data['bannerList']   = json_decode($this->_curlGetData(base_url(GET_VISA_BANNER_URL), $headers));
        $data['newsData']     = json_decode($this->_curlGetData(base_url(GET_NEWS_DATA_URL), $headers));
        $data['serviceData'] = json_decode($this->_curlGetData(base_url(GET_SERVICE_DATA_URL), $headers));

        $parentSlug = urldecode($parentSlug);
        $subSlug    = urldecode($subSlug);

        // Get parent category by slug
        $parent = $this->db
            ->where('slug', $parentSlug)
            ->where('status', 1)
            ->get('service_categories')
            ->row();

        if (!$parent) show_404();

        // Get subcategory by slug under this parent
        $subCategory = $this->db
            ->where('parent_id', $parent->id)
            ->where('slug', $subSlug)
            ->where('status', 1)
            ->get('service_categories')
            ->row();

        if (!$subCategory) show_404();

        $data['subCategory'] = $subCategory;

        $this->load->view('aa-front-end/includes/header', $data);
        $this->load->view('aa-front-end/visa-service-details', $data);
        $this->load->view('aa-front-end/includes/footer');
    }
}
