<?php
/**
 * @package         WOSA
 * @subpackage      IELTS/PTE..
 * @author          navjeet
 *
 **/
 
class Web_banner extends MY_Controller{
    
    function __construct()
    {
        parent::__construct();
        if (!$this->_is_logged_in()) {redirect('adminController/login');}
        $this->load->model('Web_banner_model');        
    }
    
    function index(){

        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        $data['si'] = 1;
        //access control ends
        $this->load->library('pagination');
        $params['limit'] = RECORDS_PER_PAGE; 
        $params['offset'] = ($this->input->get('per_page')) ? $this->input->get('per_page') : 0;
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('adminController/gallery/index?');
        $config['total_rows'] = $this->Web_banner_model->get_all_web_banner_count();
        $this->pagination->initialize($config);
        $data['title'] = 'Web Banner List';
        $data['gallery'] = $this->Web_banner_model->get_web_banner($params);        
        $data['_view'] = 'web_banner/index';
        $this->load->view('layouts/main',$data);
    }
    
    
    function add()
    {   
        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        $data['si'] = 0;
        //access control ends

        $data['internal_links']=$this->auto_InternalLinks();

        $user = $this->session->userdata('admin_login_data');

        foreach ($user as $d){$by_user=$d->id;}

        $this->load->library('form_validation');
        $this->form_validation->set_rules('heading_text','heading text','required|trim');
        $this->form_validation->set_rules('heading_text_color','heading text color','required|trim');
        $this->form_validation->set_rules('section_bg_color','heading bg color','required|trim');
        $this->form_validation->set_rules('btn_link_type','button type','trim');
        $this->form_validation->set_rules('btn_link_url','link url','trim');
        $this->form_validation->set_rules('image_video','image video','trim');
        $this->form_validation->set_rules('video_screenshot','video screen','trim');
        $data['title'] = 'Add Web Banner';
        if($this->form_validation->run())     
        { 
            if(!file_exists(WEB_BANNER_IMAGE_PATH))
            {
                mkdir(WEB_BANNER_IMAGE_PATH, 0777, true);
            }
            if(!file_exists(WEB_BANNER_VIDEO_PATH))
            {
                mkdir(WEB_BANNER_VIDEO_PATH, 0777, true);
            }

            $typep = $_FILES['image_video']['type'];
            $p=explode('/',$typep);
            $type=$p[0];
            if($type == 'image')
            {
                $config_image['upload_path']   = WEB_BANNER_IMAGE_PATH;
                $config_image['allowed_types'] = WEB_BANNER_IMAGE_TYPE;                    
                $config_image['encrypt_name']  = TRUE;
                $this->load->library('upload',$config_image);
                 $this->upload->initialize($config_image);
                if($this->upload->do_upload("image_video")){
                $data = array('upload_data' => $this->upload->data());
                $image_video= $data['upload_data']['file_name'];
                }else{
                $image_video=NULL;
                }
                
            }
            else 
            {

                /*--video-*/            
                $config_video['upload_path']   = WEB_BANNER_VIDEO_PATH;
                $config_video['allowed_types'] = WEB_BANNER_VIDEO_TYPE;                    
                $config_video['encrypt_name']  = TRUE;
                   
                $this->load->library('upload',$config_video);
                $this->upload->initialize($config_video);
                if($this->upload->do_upload("image_video")){
                $data1 = array('upload_data' => $this->upload->data());
                $image_video= $data1['upload_data']['file_name'];
                }else{                   
                $image_video=NULL;
                }
               
                /*--ends---*/

                 /*--video screen image*/
               $filename=$_FILES['video_screenshot']['name'];
                 //echo WEB_BANNER_IMAGE_TYPE;
                $config_videoimage['upload_path']   = WEB_BANNER_IMAGE_PATH;
                $config_videoimage['allowed_types'] = WEB_BANNER_IMAGE_TYPE;                    
                $config_videoimage['encrypt_name']  = TRUE; 
                      
                $this->load->library('upload',$config_videoimage);
                 $this->upload->initialize($config_videoimage);           
                if($this->upload->do_upload("video_screenshot")){
                $datasc = array('upload_data' => $this->upload->data());
                $video_screenshot= $datasc['upload_data']['file_name'];
                }else{
                     echo $this->upload->display_errors();
                $video_screenshot=NULL;
                }
                //upload doc
            }           

            $params = array(
                'heading_text'     =>  $this->input->post('heading_text'),  
                'heading_text_color'     =>  $this->input->post('heading_text_color'),
                'section_bg_color'     =>  $this->input->post('section_bg_color'),
                'btn_link_type'     =>  $this->input->post('btn_link_type'),
                'btn_link_url'     =>  $this->input->post('btn_link_url'),
                'heading_text'     =>  $this->input->post('heading_text'),        
                'desp' =>    $this->input->post('desp'),
                'btn_text'=>$this->input->post('btn_text'),
                'btn_bg_color'=>$this->input->post('btn_bg_color'),
                'btn_border_color'=>$this->input->post('btn_border_color'),
                'btn_link_type'=>$this->input->post('btn_link_type'),
                'btn_link_url'=>$this->input->post('btn_link_url'),
                'upload_type'=>$this->input->post('upload_type'),
                'sequence' =>    $this->input->post('sequence'),                
                'image_video'=>$image_video,
                'video_screenshot'=>$video_screenshot,
                'by_user'=>$by_user,
                'active'=>$this->input->post('active') ? $this->input->post('active') : 0,                            
                );

              $idd = $this->Web_banner_model->add_web_banner($params);
              if($idd)
              {
                    $this->session->set_flashdata('flsh_msg', SUCCESS_MSG);
                    if($this->Role_model->_has_access_('web_banner','index')){
                        redirect('adminController/web_banner/index');
                    }else{
                        redirect('adminController/web_banner/add');
                    } 
              }
              else
               {
                    $this->session->set_flashdata('flsh_msg', FAILED_MSG);           
                    redirect('adminController/web_banner/add');
               }

        }
        
        else
        {            
            $data['_view'] = 'web_banner/add';
            $this->load->view('layouts/main',$data);
        }
    }

 
    function edit($id)
    { 
        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        $data['si'] = 0;
        //access control ends
        $data['eid'] = $id;
        $data['banner'] = $this->Web_banner_model->get_web_banner_byid($id);
        $data['title'] = 'Edit Web Banner';
        $old_image=$data['banner']['image'];
        $data['internal_links']=$this->auto_InternalLinks();
      
        if(isset($data['banner']['id']))
        {
            $this->load->library('form_validation');
             $this->form_validation->set_rules('heading_text','heading text','required|trim');
            $this->form_validation->set_rules('heading_text_color','heading text color','required|trim');
            $this->form_validation->set_rules('section_bg_color','heading bg color','required|trim');
            $this->form_validation->set_rules('btn_link_type','button type','trim');
            $this->form_validation->set_rules('btn_link_url','link url','trim');
            $this->form_validation->set_rules('image_video','image video','trim');
            $this->form_validation->set_rules('video_screenshot','video screen','trim');
            if($this->form_validation->run())     
            { 
                if(!file_exists(WEB_BANNER_IMAGE_PATH))
                {
                    mkdir(WEB_BANNER_IMAGE_PATH, 0777, true);
                }
                if(!file_exists(WEB_BANNER_VIDEO_PATH))
                {
                    mkdir(WEB_BANNER_VIDEO_PATH, 0777, true);
                }
            if(isset($_FILES['image_video']['name']))
            {
                 $typep = $_FILES['image_video']['type'];
                 $p=explode('/',$typep);
                 $type=$p[0];
                if($type == 'image')
                {
                    $config_image['upload_path']   = WEB_BANNER_IMAGE_PATH;
                    $config_image['allowed_types'] = WEB_BANNER_IMAGE_TYPE;                    
                    $config_image['encrypt_name']  = TRUE;
                    $this->load->library('upload',$config_image);
                     $this->upload->initialize($config_image);
                    if($this->upload->do_upload("image_video")){
                    $data = array('upload_data' => $this->upload->data());

                    $image_video= $data['upload_data']['file_name'];
                         if($this->input->post('hid_image_video') !="")
                        {
                            unlink(WEB_BANNER_IMAGE_PATH.$this->input->post('hid_image_video'));
                        }
                    }
                    else
                    {                    
                    $image_video=$this->input->post('hid_image_video');
                    }
                    
                }
                else 
                {

                    /*--video-*/            
                    $config_video['upload_path']   = WEB_BANNER_VIDEO_PATH;
                    $config_video['allowed_types'] = WEB_BANNER_VIDEO_TYPE;                    
                    $config_video['encrypt_name']  = TRUE;                   
                    $this->load->library('upload',$config_video);
                    $this->upload->initialize($config_video);
                    if($this->upload->do_upload("image_video")){
                    $data1 = array('upload_data' => $this->upload->data());
                    $image_video= $data1['upload_data']['file_name'];
                    if($this->input->post('hid_image_video') !="")
                        {
                            unlink(WEB_BANNER_IMAGE_PATH.$this->input->post('hid_image_video'));
                        }
                    }else{                   
                    $image_video=$this->input->post('hid_image_video');
                    }
                   
                    /*--ends---*/

                     /*--video screen image*/
                   $filename=$_FILES['video_screenshot']['name'];
                     //echo WEB_BANNER_IMAGE_TYPE;
                    $config_videoimage['upload_path']   = WEB_BANNER_IMAGE_PATH;
                    $config_videoimage['allowed_types'] = WEB_BANNER_IMAGE_TYPE;                    
                    $config_videoimage['encrypt_name']  = TRUE; 
                          
                    $this->load->library('upload',$config_videoimage);
                     $this->upload->initialize($config_videoimage);           
                    if($this->upload->do_upload("video_screenshot")){
                    $datasc = array('upload_data' => $this->upload->data());
                    $video_screenshot= $datasc['upload_data']['file_name'];
                     if($this->input->post('hid_image_video') !="")
                        {
                            unlink(WEB_BANNER_IMAGE_PATH.$this->input->post('hid_video_screenshot'));
                        }
                    }else{
                        // echo $this->upload->display_errors();
                    $video_screenshot=$this->input->post('hid_video_screenshot');
                    }
                    //upload doc
                }

            }
            else {

                 $image_video=$this->input->post('hid_image_video');
                 $video_screenshot=$this->input->post('hid_video_screenshot');

            }
              

             $params = array(
                'heading_text'     =>  $this->input->post('heading_text'),  
                'heading_text_color'     =>  $this->input->post('heading_text_color'),
                'section_bg_color'     =>  $this->input->post('section_bg_color'),
                'btn_link_type'     =>  $this->input->post('btn_link_type'),
                'btn_link_url'     =>  $this->input->post('btn_link_url'),
                'heading_text'     =>  $this->input->post('heading_text'),        
                'desp' =>    $this->input->post('desp'),
                'btn_text'=>$this->input->post('btn_text'),
                'btn_bg_color'=>$this->input->post('btn_bg_color'),
                'btn_border_color'=>$this->input->post('btn_border_color'),
                'btn_link_type'=>$this->input->post('btn_link_type'),
                'btn_link_url'=>$this->input->post('btn_link_url'),
                'upload_type'=>$this->input->post('upload_type'),
                'sequence' =>    $this->input->post('sequence'),                
                'image_video'=>$image_video,
                'video_screenshot'=>$video_screenshot,
                'by_user'=>$by_user,
                'active'=>$this->input->post('active') ? $this->input->post('active') : 0,
                );

              $idd = $this->Web_banner_model->update_banner_details($id,$params);
              if($idd)
              {
                   $this->session->set_flashdata('flsh_msg', SUCCESS_MSG);           
                   redirect('adminController/web_banner/index');
              }
              else
               {
                    $this->session->set_flashdata('flsh_msg', FAILED_MSG);           
                    redirect('adminController/web_banner/edit/'.$id);
               }

            }
            else
            {
                $data['_view'] = 'web_banner/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error(ITEM_NOT_EXIST);
    }
    
    function remove($id)
    {
        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        //access control ends
        $user = $this->session->userdata('admin_login_data');
        foreach ($user as $d){$by_user=$d->id;}
        
        $gallery = $this->Web_banner_model->get_gallery($id);
        if(isset($gallery['id']))
        {
            if($gallery['type']==1){
                $type = 'IMAGE';
            }elseif($gallery['type']==2){
                $type = 'VIDEO';
            }else{
                $type = NA;
            }

            if($gallery['category_type']==1){
                $category = 'Home page banner';
            }elseif($gallery['category_type']==2){
                $category = 'About us page banner';
            }elseif($gallery['category_type']==3){
                $category = 'Event page';
            }elseif($gallery['category_type']==4){
                $category = 'Reality test page';
            }else{
                $category = NA;
            }
            //activity update start              
                $activity_name= WEB_MEDIA_DELETE;
                $description= 'Web media '.$type.' named as '.$gallery['image'].' for '.$category.' having PK-ID '.$id.' deleted';
                $res=$this->addUserActivity($activity_name,$description,$student_package_id=0,$by_user);
            //activity update end
            $this->Web_banner_model->delete_gallery($id);
            $del_picture=$gallery['image'];
            //unlink(WEB_MEDIA_IMAGE_PATH.$del_picture);
            $this->session->set_flashdata('flsh_msg', DEL_MSG);
            redirect('adminController/web_media/index');
        }
        else
            show_error(ITEM_NOT_EXIST);
    }    

    function ajax_check_ctgtypeadded(){
        
        $ct_type = $this->input->post('ct_type', true);
        $data= $this->Web_banner_model->get_web_media_count($ct_type);
        $count=count($data);
        $id=$data[0]->id;
        header('Content-Type: application/json');
        $response = ['count'=>$count, 'id'=>$id];
        echo json_encode($response);  
    }

    /*---Get all internal links (front end controller name)*/
    function auto_InternalLinks()
    {
        $controllers = get_filenames( APPPATH . 'controllers', FALSE, TRUE);
        foreach( $controllers as $k => $v )
        {
            if( strpos( $v, '.php' ) === FALSE)
            {
                unset( $controllers[$k] );
            }          
             
        }

        /*--mention controller name which you have to remove from list*/
        $excludedController=array(
                'Book_events.php','Book_reality_test.php','Booking.php','Campaign.php','Complaints.php','Enquiry.php','Forgot_password.php','Our_students.php','Student_reality_test_video.php'
            );
      foreach($excludedController as $excludedController)  
            {
                $key = array_search($excludedController, $controllers, true);
                if ($key !== false)
                {
                    unset($controllers[$key]);
                }

            } 
        $finallist=[];        
        $controllers_list=[];
        $controllers = str_replace('.php', '', $controllers);
         foreach( $controllers as $k => $v )
        {
            $controllers_list['title']=str_replace('_', ' ', $v);
            $p=strtolower($v);
            $controllers_list['url']=base_url("$p");            
            array_push($finallist, $controllers_list);             
        }
        
          return $finallist;
         
        
    }    
    /*---ends----*/
    function ajax_checkSequenceNo()
    {
        $seqno = $this->input->post('seqno', true);
        $id = $this->input->post('id', true);
        echo $data= $this->Web_banner_model->check_product_card_sequence($seqno,$id);
        /*$count=count($data);
        $id=$data[0]->id;
        header('Content-Type: application/json');
        $response = ['count'=>$count, 'id'=>$id];
        echo json_encode($response); */ 

    }
}
