<?php
/**
 * @package         WOSA
 * @subpackage      IELTS/PTE..
 * @author          Haroon
 *
 **/
 
class Web_media extends MY_Controller{
    
    function __construct()
    {
        parent::__construct();
        if (!$this->_is_logged_in()) {redirect('adminController/login');}
        $this->load->model('Web_media_model');        
    }
    
    function index(){

        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        $data['si'] = 1;
        //access control ends
        $this->load->library('pagination');
        $params['limit'] = RECORDS_PER_PAGE; 
        $params['offset'] = ($this->input->get('per_page')) ? $this->input->get('per_page') : 0;
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('adminController/gallery/index?');
        $config['total_rows'] = $this->Web_media_model->get_all_gallery_count();
        $this->pagination->initialize($config);
        $data['title'] = 'Web Media List';
        $data['gallery'] = $this->Web_media_model->get_all_gallery($params);        
        $data['_view'] = 'web_media/index';
        $this->load->view('layouts/main',$data);
    }
    
    function add()
    {   
        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        $data['si'] = 0;
        //access control ends
        $this->load->library('form_validation');
        $this->form_validation->set_rules('category_type','Category type','required|trim');
         $this->form_validation->set_rules('type','Type','required|trim');
        $data['title'] = 'Add Web Media';
        if($this->form_validation->run())     
        {   
            $user = $this->session->userdata('admin_login_data');
            foreach ($user as $d){$by_user=$d->id;}
            $params = array(
                'active' => $this->input->post('active') ? $this->input->post('active') : 0,
                'image'  => $this->input->post('image'),
                'type'  => $this->input->post('type'),
                'category_type'  => $this->input->post('category_type'),
                'by_user' => $by_user,
            );
            if($this->input->post('type')== 1) //image
            {
                  $config['upload_path']   = WEB_MEDIA_IMAGE_PATH;
                  $config['allowed_types'] = WEB_MEDIA_IMAGE_TYPES;
            }else{
                  $config['upload_path']   = WEB_MEDIA_VIDEO_PATH;
                  $config['allowed_types'] = WEB_MEDIA_VIDEO_TYPES;
            }
            $config['encrypt_name']  = FALSE;         
            $this->load->library('upload',$config);

                if($this->upload->do_upload("image")){
                    $data = array('upload_data' => $this->upload->data());
                    $image= $data['upload_data']['file_name'];
                    $params = array(
                        'active' => $this->input->post('active') ? $this->input->post('active') : 0,
                        'image' => $image,
                        'type'  => $this->input->post('type'),
                        'category_type'  => $this->input->post('category_type'),
                        'by_user' => $by_user,
                    );
                    $id = $this->Web_media_model->add_gallery($params);
                    if($id){
                        if($params['type']==1){
                            $type = 'IMAGE';
                        }elseif($params['type']==2){
                            $type = 'VIDEO';
                        }else{
                            $type = NA;
                        }

                        if($params['category_type']==1){
                            $category = 'Home page banner';
                        }elseif($params['category_type']==2){
                            $category = 'About us page banner';
                        }elseif($params['category_type']==3){
                            $category = 'Event page';
                        }elseif($params['category_type']==4){
                            $category = 'Reality test page';
                        }else{
                            $category = NA;
                        }
                        //activity update start              
                            $activity_name= WEB_MEDIA_ADD;
                            $description= 'Web media '.$type.' named as '.$image.' for '.$category.' added';
                            $res=$this->addUserActivity($activity_name,$description,$student_package_id=0,$by_user);
                        //activity update end
                        $this->session->set_flashdata('flsh_msg', SUCCESS_MSG);
                        if($this->Role_model->_has_access_('web_media','index')){
                            redirect('adminController/web_media/index');
                        }else{
                            redirect('adminController/web_media/add');
                        }
                        
                    }else{
                        $this->session->set_flashdata('flsh_msg', FAILED_MSG);
                        redirect('adminController/web_media/add');
                    }                    
                    
                }else{
                    $this->session->set_flashdata('flsh_msg', FAILED_MSG);
                    redirect('adminController/web_media/add');
                } 
        }
        else
        {            
            $data['_view'] = 'web_media/add';
            $this->load->view('layouts/main',$data);
        }
    }
    
    function edit($id)
    { 
        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        $data['si'] = 0;
        //access control ends
        $data['gallery'] = $this->Web_media_model->get_gallery($id);
        $data['title'] = 'Edit Web Media';
        $old_image=$data['gallery']['image'];
      
        if(isset($data['gallery']['id']))
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('category_type','Category type','required|trim');
            $this->form_validation->set_rules('type','Type','required|trim'); 
            if($this->form_validation->run())     
            {   
                $user = $this->session->userdata('admin_login_data');
                foreach ($user as $d){$by_user=$d->id;}
                $params = array(
                    'active' => $this->input->post('active') ? $this->input->post('active') : 0,
                    'type'  => $this->input->post('type'),
                    'category_type'  => $this->input->post('category_type'),
                    'by_user' => $by_user,
                );
                if( $this->input->post('type') == 1){
                  $config['upload_path']   = WEB_MEDIA_IMAGE_PATH;
                  $config['allowed_types'] = WEB_MEDIA_IMAGE_TYPES;
                }else{
                  $config['upload_path']   = WEB_MEDIA_VIDEO_PATH;
                  $config['allowed_types'] = WEB_MEDIA_VIDEO_TYPES;

                  $old_image=$data['gallery']['image'];
                   unlink(WEB_MEDIA_VIDEO_PATH.'/'.$old_image);
                }
                $config['encrypt_name']  = FALSE;         
                $this->load->library('upload',$config);

                if($this->upload->do_upload("image")){
                    $data = array('upload_data' => $this->upload->data());
                    $image= $data['upload_data']['file_name'];
                    $params = array(
                        'active' => $this->input->post('active') ? $this->input->post('active') : 0,
                        'image' => $image,
                        'type'  => $this->input->post('type'),
                        'category_type'  => $this->input->post('category_type'),
                        'by_user' => $by_user,
                    );  

                }else{
                    $params = array(
                        'active' => $this->input->post('active') ? $this->input->post('active') : 0,
                        'type'  => $this->input->post('type'),
                        'category_type'  => $this->input->post('category_type'),
                        'by_user' => $by_user,
                    );
                }
                $idd = $this->Web_media_model->update_gallery($id,$params);
                if($idd){
                        
                        if($params['type']==1){
                            $type = 'IMAGE';
                        }elseif($params['type']==2){
                            $type = 'VIDEO';
                        }else{
                            $type = NA;
                        }

                        if($params['category_type']==1){
                            $category = 'Home page banner';
                        }elseif($params['category_type']==2){
                            $category = 'About us page banner';
                        }elseif($params['category_type']==3){
                            $category = 'Event page';
                        }elseif($params['category_type']==4){
                            $category = 'Reality test page';
                        }else{
                            $category = NA;
                        }
                        //activity update start              
                            $activity_name= WEB_MEDIA_UPDATE;
                            $description= 'Web media '.$type.' named as '.$image.' for '.$category.' updated';
                            $res=$this->addUserActivity($activity_name,$description,$student_package_id=0,$by_user);
                        //activity update end
                    $this->session->set_flashdata('flsh_msg', UPDATE_MSG);           
                    redirect('adminController/web_media/index');
                }else{
                    $this->session->set_flashdata('flsh_msg', UPDATE_FAILED_MSG);           
                    redirect('adminController/web_media/edit/'.$id);
                }                
            }
            else
            {
                $data['_view'] = 'web_media/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error(ITEM_NOT_EXIST);
    }
    
    function remove($id)
    {
        //access control start
        $cn = $this->router->fetch_class().''.'.php';
        $mn = $this->router->fetch_method();        
        if(!$this->_has_access($cn,$mn)) {redirect('adminController/error_cl/index');}
        //access control ends
        $user = $this->session->userdata('admin_login_data');
        foreach ($user as $d){$by_user=$d->id;}
        
        $gallery = $this->Web_media_model->get_gallery($id);
        if(isset($gallery['id']))
        {
            if($gallery['type']==1){
                $type = 'IMAGE';
            }elseif($gallery['type']==2){
                $type = 'VIDEO';
            }else{
                $type = NA;
            }

            if($gallery['category_type']==1){
                $category = 'Home page banner';
            }elseif($gallery['category_type']==2){
                $category = 'About us page banner';
            }elseif($gallery['category_type']==3){
                $category = 'Event page';
            }elseif($gallery['category_type']==4){
                $category = 'Reality test page';
            }else{
                $category = NA;
            }
            //activity update start              
                $activity_name= WEB_MEDIA_DELETE;
                $description= 'Web media '.$type.' named as '.$gallery['image'].' for '.$category.' having PK-ID '.$id.' deleted';
                $res=$this->addUserActivity($activity_name,$description,$student_package_id=0,$by_user);
            //activity update end
            $this->Web_media_model->delete_gallery($id);
            $del_picture=$gallery['image'];
            //unlink(WEB_MEDIA_IMAGE_PATH.$del_picture);
            $this->session->set_flashdata('flsh_msg', DEL_MSG);
            redirect('adminController/web_media/index');
        }
        else
            show_error(ITEM_NOT_EXIST);
    }    

    function ajax_check_ctgtypeadded(){
        
        $ct_type = $this->input->post('ct_type', true);
        $data= $this->Web_media_model->get_web_media_count($ct_type);
        $count=count($data);
        $id=$data[0]->id;
        header('Content-Type: application/json');
        $response = ['count'=>$count, 'id'=>$id];
        echo json_encode($response);  
    }
    
}
