<?php
/**
 * @package         WOSA
 * @subpackage      IELTS/PTE..
 * @author          navjeet
 *
 **/
 
class Web_banner_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get role by id
     */
    function get_web_banner_byid($id)
    {
        return $this->db->get_where('web_banner_details',array('id'=>$id))->row_array();
    }
    
    /*
     * Get all roles count
     */
    function get_all_web_banner_count()
    {
        $this->db->from('web_banner_details');
        return $this->db->count_all_results();
    }

    function get_all_gallery_active()
    {
        $this->db->order_by('id', 'desc');  
        $this->db->where('active', 1);           
        return $this->db->get('web_banner_details')->result_array();
    }
        
    /*
     * Get all roles
     */
    function get_web_banner($params = array())
    {
        $this->db->order_by('id', 'desc');
        if(isset($params) && !empty($params))
        {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get('web_banner_details')->result_array();
    }
        
    /*
     * function to add new role
     */
    function add_web_banner($params)
    {
        $this->db->insert('web_banner_details',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update role
     */
    function update_banner_details($id,$params)
    {
        $this->db->where('id',$id);
        return $this->db->update('web_banner_details',$params);
    }
    
    /*
     * function to delete role
     */
    function delete_gallery($id)
    {
        return $this->db->delete('web_banner_details',array('id'=>$id));
    }

     /*
     * function to update 
     */
    function update_one($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `active`=".$active." WHERE ".$pk." = ".$id." ");
        //print_r($this->db->last_query());exit;
    }

    function update_null($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `active`= NULL WHERE ".$pk." = ".$id." ");
        //print_r($this->db->last_query());exit;
    }

    /*
     * function to update 
     */
    function update_one_enq($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `enqActive`=".$active." WHERE ".$pk." = ".$id." ");
    }

    function update_null_enq($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `enqActive`= NULL WHERE ".$pk." = ".$id." ");
    }

    function update_one_hasAcademy($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `hasAcademy`=".$active." WHERE ".$pk." = ".$id." ");
    }

    function update_null_hasAcademy($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `hasAcademy`= NULL WHERE ".$pk." = ".$id." ");
    }

    function update_one_hasVISA($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `hasVISA`=".$active." WHERE ".$pk." = ".$id." ");
    }

    function update_null_hasVISA($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `hasVISA`= NULL WHERE ".$pk." = ".$id." ");
    }

    /*
     * function to update 
     */
    function update_one_is_team($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `is_team`=".$active." WHERE ".$pk." = ".$id." ");
        //print_r($this->db->last_query());exit;
    }

    function update_null_is_team($id, $active, $table, $pk)
    {        
        return $this->db->query("UPDATE ".$table." SET `is_team`= NULL WHERE ".$pk." = ".$id." ");
        //print_r($this->db->last_query());exit;
    }

    /*
     * function to update 
     */
    function update_rf($id, $fresh, $table, $pk, $todaystr)
    {        
        if($fresh==0){
            $fresh=1;
        }else{
           $fresh=0; 
        }
        return $this->db->query("UPDATE ".$table." SET `fresh`=".$fresh." , `today`=".$todaystr." WHERE ".$pk." = ".$id." ");
    }


    function get_web_media_count($id)
    {
        $this->db->select('id');
        $this->db->where(array('category_type'=>$id));         
        return $this->db->get('web_banner_details')->result();
    }

    function get_all_web_media($category_type)
    {
        $this->db->select('`category_type`, `image`');
        $this->db->order_by('id', 'desc');  
         $this->db->where(array('category_type'=>$category_type,'active'=> 1));         
        return $this->db->get('web_banner_details')->result_array();
    }
     function check_product_card_sequence($seqno,$id)
    {
         $this->db->where(array('sequence'=>$seqno,'id!='=>$id));         
        return $this->db->get('web_banner_details')->num_rows();


    }

    
}
