<div class="container mt-5"> <!-- mt-5 adds top margin -->
    <div class="row gx-4 gy-4"> <!-- gx-4: horizontal gap, gy-4: vertical gap -->

        <?php if (!empty($isSubCategoryPage) && $isSubCategoryPage): ?>

            <!-- Subcategories grid -->
            <?php foreach ($subCategories as $sub): ?>
                <div class="col-md-3 col-sm-6">
                    <a href="<?= base_url('visa-services/' . urlencode($parentSlug) . '/' . urlencode($sub->slug)) ?>">
                        <div class="services">
                            <div class="img-area">
                                <img src="<?= base_url($sub->image) ?>" class="img-responsive" alt="<?= htmlspecialchars($sub->name) ?>">
                            </div>
                            <div class="img-text">
                                <h4><?= htmlspecialchars($sub->name) ?></h4>
                                <span class="ft-btn btn btn-blue btn-circled btn-sm mt-5">
                                    Find Out More <i class="fa fa-chevron-right font-10"></i>
                                </span>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>

        <?php else: ?>

            <!-- Main page grid: parent categories -->
            <?php foreach ($categories as $cat): ?>
                <div class="col-md-3 col-sm-6">
                    <a href="<?= base_url('visa-services/' . urlencode($cat->slug)) ?>">
                        <div class="services">
                            <div class="img-area">
                                <?php if(!empty($cat->image)): ?>
                                    <img src="<?= base_url($cat->image) ?>" class="img-responsive" alt="<?= htmlspecialchars($cat->name) ?>">
                                <?php endif; ?>
                            </div>
                            <div class="img-text">
                                <h4><?= htmlspecialchars($cat->name) ?></h4>
                                <span class="ft-btn btn btn-blue btn-circled btn-sm mt-5">
                                    View Subcategories <i class="fa fa-chevron-right font-10"></i>
                                </span>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>

        <?php endif; ?>

    </div>
</div>
