document.addEventListener('DOMContentLoaded', () => {
	let elements = document.querySelectorAll('.list-item');
	Array.prototype.forEach.call(elements, function(el) {
		let all = el.querySelectorAll('a.link-arrow');
		all.forEach((value, key) => {
			value.classList.add('up');
			// if(value.classList.contains('link-current')) {--for by default active
			// 	value.classList.add('active', 'down');
			// 	value.nextElementSibling.style.display = 'block';
			// }
			if(value.classList.contains('')) {
				value.classList.add('active', 'down');
				value.nextElementSibling.style.display = 'block';
			}
			value.addEventListener('click', (event) => {
				event.preventDefault();
				let slideToggle = (target, duration = 500) => {
					if(window.getComputedStyle(target).display === 'none') {
						return slideDown(target, duration);
					} else {
						return slideUp(target, duration);
					}
				};
				slideToggle(value.nextElementSibling, 200);
				if(value.classList.contains('down')) {
					value.classList.toggle('rotate-revert');
				}
				value.classList.add('transition');
				value.classList.toggle('active');
				value.classList.toggle('rotate');
				!(value.classList.contains('link-current')) ? value.classList.add('link-current'): value.classList.remove('link-current');
			});
		});
	});
	let slideUp = (target, duration = 500) => {
		target.style.transitionProperty = 'height, margin, padding';
		target.style.transitionDuration = duration + 'ms';
		target.style.boxSizing = 'border-box';
		target.style.height = target.offsetHeight + 'px';
		target.offsetHeight;
		target.style.overflow = 'hidden';
		target.style.height = 0;
		target.style.paddingTop = 0;
		target.style.paddingBottom = 0;
		target.style.marginTop = 0;
		target.style.marginBottom = 0;
		window.setTimeout(() => {
			target.style.display = 'none';
			target.style.removeProperty('height');
			target.style.removeProperty('padding-top');
			target.style.removeProperty('padding-bottom');
			target.style.removeProperty('margin-top');
			target.style.removeProperty('margin-bottom');
			target.style.removeProperty('overflow');
			target.style.removeProperty('transition-duration');
			target.style.removeProperty('transition-property');
		}, duration);
	}
	let slideDown = (target, duration = 500) => {
		target.style.removeProperty('display');
		let display = window.getComputedStyle(target).display;
		if(display === 'none') display = 'block';
		target.style.display = display;
		let height = target.offsetHeight;
		target.style.overflow = 'hidden';
		target.style.height = 0;
		target.style.paddingTop = 0;
		target.style.paddingBottom = 0;
		target.style.marginTop = 0;
		target.style.marginBottom = 0;
		target.offsetHeight;
		target.style.boxSizing = 'border-box';
		target.style.transitionProperty = 'height, margin, padding';
		target.style.transitionDuration = duration + 'ms';
		target.style.height = height + 'px';
		target.style.removeProperty('padding-top');
		target.style.removeProperty('padding-bottom');
		target.style.removeProperty('margin-top');
		target.style.removeProperty('margin-bottom');
		window.setTimeout(() => {
			target.style.removeProperty('height');
			target.style.removeProperty('overflow');
			target.style.removeProperty('transition-duration');
			target.style.removeProperty('transition-property');
		}, duration);
	}
});
/*-----SIDEBAR DROPDOWN MENU---*/
function myFunction() {
	document.getElementById("myDropdown").classList.toggle("show");
}
$(function() {
	$("#toggle").on('click', function() {
		$(".fa-angle-right").toggleClass("drp-rotate");
	});
});


/*-----END SIDEBAR DROPDOWN MENU---*/





